package gov.va.vinci.dart.json.builder;

import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.json.DocumentTemplateView;

/**
 * The Class DocumentTemplateViewBuilder.
 */
public class DocumentTemplateViewBuilder {

    /**
     * Builds the.
     *
     * @param template the template
     * @return the document template view
     */
    public DocumentTemplateView build(final DocumentTemplate template) {
        DocumentTemplateView result = new DocumentTemplateView();

        result.setId(template.getId());
        result.setName(template.getName());

        String descrStr = template.getDescription();
        if (descrStr == null || descrStr.isEmpty()) {
            descrStr = template.getName();
        }

        result.setDescription(descrStr);

        result.setLocation(template.isLocation());
        result.setParticipant(template.isParticipant());
        result.setPrincipalInvestigator(template.isPrincipalInvestigator());
        result.setAdministrator(template.isAdministrator());
        result.setActivityType(template.getActivityType());
        result.setSortOrder(template.getSortOrder());

        return result;
    }
}
